<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


/**
* description
*
* @library	
* @author	
* @since	
*/
class CMenus extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "menus";
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;



		if ($_GET["mod"] == $this->name) {
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule($this->name);
		parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];


			switch ($_GET["sub"]) {
				case "landing":

					$menu = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_zones']} LIMIT 1");
					if (is_array($menu)) {
						$_GET["menu_id"] = $menu["menu_id"];
						$_GET["search"] = "1";
						$sub = "items";
					}
					
				case "menus":
					
				case "items":
				case "items.cat":

					if ($_GET["item_id"] && $_GET["action"] == "itemdetails") {

						$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_items']} WHERE item_id=%d" , array($_GET["item_id"]));

						if (($item["item_type"] == "4") && !$item["item_cat_type"]) {

							$url = parse_url($_SERVER["HTTP_REFERER"]);
							parse_str($url["query"] , $vars);
						
							if (($vars["action"] == "add") ) {
								$_GET["section"] = "1";
							}


							if ($_GET["section"] == "1") {
								$list = new CSQLAdmin("items.cat" , $this->__parent_templates,$this->db,$this->tables,$extra);
								$this->PrepareColor($list->forms["forms"] , $sub);

								$list->functions = array( 
										"list_process"	=> array(&$this , "ProcessItems"),
								);					

								$extra["details"]["after"] = $list->DoEvents();
							}							
						}						
					}

					$data = new CSQLAdmin($sub , $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					$this->PrepareMenuTabs($data->forms["forms"] , $sub);
					$this->PrepareItemFields($data->forms["forms"] , $sub);
					$this->PrepareColor($data->forms["forms"] , $sub);

					switch ($sub) {
						case "items":
							$data->functions = array( 
									"onstore_prepare"	=> array(&$this , "StoreMenuItem"),
									"list_process"		=> array(&$this , "ProcessItems"),
									"ondelete"			=> array(&$this , "DeleteMenuItem"),
							);					
						break;

						case "items.cat":
							$data->functions = array( 
									"onstore"		=> array(&$this , "StoreDropDownItem"),
							);					
						break;

					}
					
					return $data->DoEvents();

				break;

			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items , $count) {

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				switch ($val["item_type"]) {
					//instance
					case "1":
						$mod = $this->plugins["modules"]->getModuleInfo($val["item_module"] , false);
						$items[$key]["item_name"] = $mod["mod_name"];							
					break;

					//global
					case "2":
						$mod = $this->plugins["modules"]->LoadDefaultModule($val["item_module_global"] , "id");
						$items[$key]["item_name"] = $mod["module_name"];
					break;

				}
				

				if ($val["item_link_type"] == "3") {
					$mod = $this->plugins["modules"]->LoadDefaultModule($val["item_module"] , "id");
					$items[$key]["item_title"] = $mod["module_name"];
				}
			}			
		}



		return array(
			"items"	=> $items,
			"count"	=> $count
		);

	}

	
	function PrepareMenuTabs(&$forms , $sub) {
		global $_SESS , $base;


		//prepare order tabs
		$statuses = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:menu_zones']} ORDER BY menu_name ASC");

		if (is_array($statuses)) {
			foreach ($statuses as $key => $val) {

				$links = array();

				if ($base->acl->checkModRule($this->tpl_module , "settings")) {
					$links[] = array (
						"title"		=> "Settings",
						"icon"		=> "settings",
						"subtitle"	=> "Status, display rules & trigger button.",
						"link"		=> "index.php?mod=menus&sub=menus&action=details&menu_id={$val[menu_id]}",
						"acl"		=> "settings"
					);
				}
				
				if ($base->acl->checkModRule($this->tpl_module , "items.list")) {
					$links[] = array (
						"title"		=> "Menu Items",
						"icon"		=> "list",
						"subtitle"	=> "Links, drop menus & mega menus.",
						"link"		=> "index.php?mod=menus&sub=items&menu_id={$val[menu_id]}&search=1",
						"acl"		=> "items.list"
					);
				}

				$tab = array(
					"color"	=> $val["menu_color"],
					"icon"	=> $val["menu_icon"] ? $val["menu_icon"] : "navlinks",
					"title"	=> $val["menu_name"],
					"subtitle"	=> "",
					"link"		=> $links
				);

				if (is_array($forms["search"])) {
					$forms["search"]["tabs"]["ts_{$val[menu_id]}"] = $tab;
				} else {
					$forms["list"]["tabs"]["ts_{$val[menu_id]}"] = $tab;
				}
				
				$forms["add"]["tabs"]["ts_{$val[menu_id]}"] = 
				$forms["details"]["tabs"]["ts_{$val[menu_id]}"] = 
				$forms["edit"]["tabs"]["ts_{$val[menu_id]}"] = $tab;
			}			
		}		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareColor(&$forms , $sub) {
		if ($_REQUEST["menu_id"]) {
			$menu = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_zones']} WHERE menu_id=%d " , array($_REQUEST["menu_id"]));
		} elseif ($_REQUEST["item_id"]) {
			$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_items']} WHERE item_id=%d " , array($_REQUEST["item_id"]));
			if (iS_array($item)) {
				$menu = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_zones']} WHERE menu_id=%d " , array($item["menu_id"]));
			}			
		} elseif ($_REQUEST["item_parent"]) {
			$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_items']} WHERE item_id=%d " , array($_REQUEST["item_parent"]));
			if (iS_array($item)) {
				$menu = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_zones']} WHERE menu_id=%d " , array($item["menu_id"]));
			}			
		}

		if (is_array($menu)) {
			$forms["add"]["skin"] = 
			$forms["edit"]["skin"] = 
			$forms["details"]["skin"] = 
			$forms["list"]["skin"] = $menu["menu_color"];
		}

	}


		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareItemFields(&$forms , $sub) {


		if (($sub == "items") && ($_GET["action"] == "itemdetails")) {			

			$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_items']} WHERE item_id=%d " , array($_GET["item_id"]));
		
			if (($item["item_type"] == "4") && !$item["item_cat_type"]) {
				$forms["details"]["title"] = $forms["details"]["title_links"];
			}			

		}
		
	}

	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreDropDownItem($record) {

		if ($record["item_parent"]) {

			$parent = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:menu_items']} WHERE item_id=%d" , array($record["item_parent"]));

			$this->db->QueryUpdate(
				$this->tables["core:menu_items"],
				array(
					"menu_id"	=> $parent["menu_id"]
				),
				"item_id={$record[item_id]}"
			);

			$this->db->QueryUpdate(
				$this->tables["core:menu_items_lang"],
				array(
					"menu_id"	=> $parent["menu_id"]
				),
				"item_id={$record[item_id]}"
			);

		}
		
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetAdminMenus() {
		$menus = $this->db->QFetchRowArray("SELECT *  FROM {$this->tables['core:menu_zones']} ORDER BY menu_id ASC");
			
		if (is_array($menus)) {
			foreach ($menus as $key => $val) {
				$menus[$key] = array(
					"title"	=> $val["menu_name"] . " Nav Menu",
					"link"	=> $val["menu_id"],
					"icon"	=> $val["menu_icon"] ? $val["menu_icon"] : "navlinks"
				);
			}			
		}
		
		return $menus;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __getAdminMenu($menu) {
		global $_LANG_ID;

		$items = $this->db->QFetchRowArray("
			SELECT * FROM 
				{$this->tables['core:languages']} as ml,
				{$this->tables['core:menu_items']} as i, 
				{$this->tables['core:menu_items_lang']} as l 
			WHERE
				i.item_id = l.item_id AND 
				l.lang_id = ml.lang_id	AND 
				ml.lang_default = 1 AND 
				i.menu_id = {$menu} AND 
				item_parent = 0
			ORDER BY 
				item_order ASC
			");


		if (!is_array($items)) {
			return null;
		}

		$status = array(
			"1"	=> " green",
			"2"	=> " orange",
			"0"	=> " red"
		);
		
		foreach ($items as $key => $val) {

			$link = array(
				"title"		=> $val["item_name"],
				"e_class"	=> $status[$val["item_status"]] . " " . ($val["item_protected"] == "1"  ? " is-protected " : ""),
				"icon"		=> "sign-file-text",
				"selected"	=> "",
				"protected"	=> $val["item_protected"] == "1" ? 1 : 0 ,
				"prio"		=> 20,
			);

			switch ($val["item_type"]) {

				//instance module
				case "1":
					$mod = $this->plugins["modules"]->GetModuleInfo($val["item_module"]);
					$link["title"] = $mod["mod_name"];
					$link["link"] = "index.php?mod=" . $mod["mod_module_code"] . "&sub=landing&module_id=" . $mod["mod_id"];

					if (($_GET["mod"] == $mod["mod_module_code"]) && ($_GET["module_id"] == $mod["mod_id"])) {
						$link["selected"] = true;
					}

					$link["acl"] = $mod["mod_id"] . ":*," . $mod["mod_module_code"] . ":*";
				break;

				//global module
				case "2":
					$link["icon"] = "sign-globalmodules";
					$mod = $this->plugins["modules"]->GetDefaultModuleInfoById($val["item_module_global"]);
					$link["title"] = $mod["module_name"];
					$link["link"] = "index.php?mod=" . $mod["module_code"] . "&sub=landing";

					if ($_GET["mod"] == $mod["module_code"]) {
						$link["selected"] = true;
					}

					$link["acl"] = $mod["module_code"] . ":*";

				break;

				//link to page
				case "3":
					$link["icon"] = "sign-link";
					$link["link"] = "index.php?mod=menus&sub=items&action=itemdetails&menu_id={$val[menu_id]}&item_id=" . $val["item_id"];
					if (isModSub("menus" , "items" ) && ($_GET["item_id"] == $val["item_id"])) {
						$link["selected"] = true ;
					}
					$link["acl"] = "menus:items.edit";
				
				break;

				//drop menu
				case "4":
					$link["icon"] = "sign-menu9";					

					$_links = array();

					switch ($val["item_cat_type"]) {
						//manual links
						case "0":
							$link["cat"] = 1;

							$_items = $this->db->QFetchRowArray("
								SELECT * FROM 
									{$this->tables['core:languages']} as ml,
									{$this->tables['core:menu_items']} as i, 
									{$this->tables['core:menu_items_lang']} as l 
								WHERE
									i.item_id = l.item_id AND 
									l.lang_id = ml.lang_id	AND 
									ml.lang_default = 1 AND 
									i.menu_id = {$menu} AND 
									item_parent = {$val[item_id]}
								ORDER BY 
									item_order ASC
								");

							if (is_array($_items)) {
	
								foreach ($_items as $k => $v) {

									$_link = array(
										"title"		=> $v["item_name"],
										"e_class"	=> $status[$v["item_status"]] . " " . ($v["item_protected"] == "1"  ? " is-protected " : ""),
										"icon"		=> "sign-file-text",
										"selected"	=> "",
										"protected"	=> $v["item_protected"] == "1" ? 1 : 0 ,
										"prio"		=> 20,
									);



									switch ($v["item_type"]) {
										//instance module
										case "1":
											$_link["icon"] = "sign-file-text";
											$mod = $this->plugins["modules"]->GetModuleInfo($v["item_module"]);
											$_link["title"] = $mod["mod_name"];
											$_link["link"] = "index.php?mod=" . $mod["mod_module_code"] . "&sub=landing&module_id=" . $mod["mod_id"];

											if (($_GET["mod"] == $mod["mod_module_code"]) && ($_GET["module_id"] == $mod["mod_id"])) {
												$_link["selected"] = true;
											}	

											$_link["acl"] = $mod["mod_id"] . ":*," . $mod["mod_module_code"] . ":*";
										break;

										//global module
										case "2":
											$_link["icon"] = "sign-globalmodules";
											$mod = $this->plugins["modules"]->GetDefaultModuleInfoById($v["item_module_global"]);
											$_link["title"] = $mod["module_name"];
											$_link["link"] = "index.php?mod=" . $mod["module_code"] . "&sub=landing";

											if ($_GET["mod"] == $mod["module_code"]) {
												$_link["selected"] = true;
											}

											$_link["acl"] = $mod["module_code"] . ":*";

										break;

										//link to page
										case "3":
											$_link["icon"] = "sign-link";
											$_link["link"] = "index.php?mod=menus&sub=items&action=itemdetails&menu_id={$v[menu_id]}&item_id=" . $v["item_id"];
											if (isModSub("menus" , "items" ) && ($_GET["item_id"] == $v["item_id"])) {
												$_link["selected"] = true ;
											}										

											$_link["acl"] = "menus:items.edit";
										break;
									}


									$_links[] = $_link;

								}
								
							}						
						break;

						case "1":
							$link["cat"] = 1;

							$_items = $this->plugins["modules"]->GetModulesByParent($val["item_cat_categories"]);

							if (is_array($_items)) {

								foreach ($_items as $k => $v) {

									$_links[] = array(
										"title"		=> $v["mod_name"],
										"e_class"	=> $status[$v["mod_status"]] . " " . ($v["item_protected"] == "1"  ? " is-protected " : ""),
										"icon"		=> "sign-file-text",
										"link"		=> "index.php?mod=" . $v["mod_module_code"] . "&sub=landing&module_id=" . $v["mod_id"],
										"selected"	=> ($_GET["mod"] == $v["mod_module_code"]) && ($_GET["module_id"] == $v["mod_id"]) ? true : false,
										"protected"	=> $v["mod_protected"] == "1" ? 1 : 0 ,
										"prio"		=> 20,
										"acl"		=> $v["mod_id"] . ":*," . $v["mod_module_code"] . ":*"
									);
								}
							}
							
						break;
					}
					

					if (!count($_links)) {
						$link["link"] = "index.php?mod=menus&sub=items&action=itemdetails&menu_id={$val[menu_id]}&item_id=" . $val["item_id"];
						$link["acl"] = "menus:items.edit";
						if (isModSub("menus" , "items" ) && ($_GET["item_id"] == $val["item_id"])) {
							$link["selected"] = true ;
						}										

					} else {					
						$link["link"] = $_links;
					}


				break;

				//link mega menu
				case "5":
					$link["icon"] = "sign-menu5";

					$_links = array();

					switch ($val["item_mega_type"]) {
						//megamenu categories
						case "0":
							$link["cat"] = 1;

							if (trim($val["item_mega_categories"])) {
							
								$cats = explode("," , $val["item_mega_categories"]);

								if (count($cats)) {
									foreach ($cats as $_k => $_v) {
										$_items = $this->plugins["modules"]->GetModulesByParent($_v);

										if (is_array($_items)) {
											foreach ($_items as $k => $v) {

												$_links[] = array(
													"title"		=> $v["mod_name"],
													"e_class"	=> $status[$v["mod_status"]] . " " . ($v["item_protected"] == "1"  ? " is-protected " : ""),
													"icon"		=> "sign-file-text",
													"link"		=> "index.php?mod=" . $v["mod_module_code"] . "&sub=landing&module_id=" . $v["mod_id"],
													"selected"	=> ($_GET["mod"] == $v["mod_module_code"]) && ($_GET["module_id"] == $v["mod_id"]) ? true : false,
													"protected"	=> $v["mod_protected"] == "1" ? 1 : 0 ,
													"prio"		=> 20,
													"acl"		=> $v["mod_id"] . ":*," . $v["mod_module_code"] . ":*"
												);
											}
										}									
									}								
								}							
							}
						break;

						//select layout
						case "1":
						break;

					}
					
					if (!count($_links)) {
						$link["link"] = "index.php?mod=menus&sub=items&action=itemdetails&menu_id={$val[menu_id]}&item_id=" . $val["item_id"];
						$link["acl"] = "menus:items.edit";

						if (isModSub("menus" , "items" ) && ($_GET["item_id"] == $val["item_id"])) {
							$link["selected"] = true ;
						}										

					} else {					
						$link["link"] = $_links;
					}


				break;

				//text
				case "6":
					$link["icon"] = "sign-pen3";
					$link["link"] = "index.php?mod=menus&sub=items&action=itemdetails&menu_id={$val[menu_id]}&item_id=" . $val["item_id"];
					if (isModSub("menus" , "items" ) && ($_GET["item_id"] == $val["item_id"])) {
						$link["selected"] = true ;
					}

					$link["acl"] = "menus:items.edit";
				
				break;

			}

	
			$links[] = $link;
		}

		return $links;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteMenuItem($record) {
		$this->db->Query("
			DELETE FROM 
				{$this->tables['core:menu_items_lang']} 
			WHERE 
				item_id IN ( 
					SELECT item_id 
					FROM {$this->tables['core:menu_items']}
					WHERE item_parent = %d
				)",
			array($record["item_id"])
		);

		$this->db->Query("
			DELETE FROM {$this->tables['core:menu_items']}
			WHERE item_parent = %d
			",
			array($record["item_id"])
		);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreMenuItem($record) {
		global $_SESS;

		if (!$record["item_id"] && $record["menu_id"] && STP_ENABLE_MENU_AUTOCHAGE) {
			$_SESS["__cms"]["side_menu"] = $record["menu_id"];
		}
		
	}
	
}


?>